#include "game.h"
#include "models.h"
#include "bezierpaths.h"

struct{
	sEnemyEntry* ee;
	int timer;
	int next;
}level;

sEnemyEntry level1enemies[] =
{
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[0],-60,0,3,50},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[0],-30,0,3,50},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,50},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[0],30,0,3,50},
	{80,(sFace*)&enemy_faces,(int*)&bezierpaths[0],60,0,3,50},

	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,-10,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,-5,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,5,3,60},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,10,3,60},

	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[2],0,0,3,100},

	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,3,100},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[3],0,0,3,90},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,3,100},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[3],0,0,3,90},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,3,100},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[3],0,0,3,90},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,3,100},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[3],0,0,3,90},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,3,100},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[3],0,0,3,90},
	{0,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,3,100},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[3],0,0,3,90},

	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},
	{150,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,3,60},

	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},
	{150,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,60},

	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{30,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},

	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[8],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[9],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[8],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[9],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[8],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[9],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[8],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[9],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[8],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[9],0,0,4,60},
	{15,(sFace*)&enemy_faces,(int*)&bezierpaths[8],0,0,4,60},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[9],0,0,4,60},

	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,4,100},
	{25,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,90},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,4,100},
	{25,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,90},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,4,100},
	{25,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,90},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,4,100},
	{25,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,90},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,4,100},
	{25,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,90},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[4],0,0,4,100},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[6],0,0,4,90},

	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},
	{200,(sFace*)&enemy_faces,(int*)&bezierpaths[7],0,0,4,60},

	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},
	{10,(sFace*)&enemy_faces,(int*)&bezierpaths[10],0,0,4,60},

	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{20,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[5],0,0,4,30},

	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,60},
	{18,(sFace*)&enemy_faces,(int*)&bezierpaths[1],0,0,3,60},
	{100,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,100},

	{0xFFFFFF,(sFace*)&enemy_faces,(int*)&bezierpaths[0],0,0,3,30},
};


void InitLevel(void)
{
	active_enemies = 0;
	active_playerbullets = 0;
	active_enemybullets = 0;

	player.x = 120<<8;
	player.y = 140<<8;
	player.shootcooldown = 0;

	level.ee = (sEnemyEntry*)&level1enemies;
	level.timer = 0;
	level.next = 0;
	player.m.f = (sFace*)&player_faces;
}

void UpdateLevel(void)
{
	if(level.timer) level.timer--;
	while(!level.timer)
	{
		sEnemyEntry* e = &level1enemies[level.next++];
		NewEnemy(e->f,e->bezierpath,e->bezx,e->bezy,e->hp,e->shootcooldown);
		level.timer = e->time;
	}
}

